#include <stdlib.h>
#include <avr/io.h>
#include <inttypes.h>
//#include <avr/signal.h>
#include <avr/interrupt.h>
#include <avr/wdt.h>
#include <avr/sleep.h>
#include "adc.c"
#include "watchdog.c"

/* Juhuu, endlich mal verschwenderisch mit den Ressourcen umgehen drfen!!!*/
/* Ich _liebe_ globale Variablen!!!*/

uint16_t adc;		 // ADC-Maximum generell:16384
uint16_t min=5512;  // 2180
uint16_t max=6916;  // 2980
					
uint8_t gruen=0,rot=0;

int main(void)
{

DDRB  |= (1<<PB0)|(1<<PB1)|(1<<PB3)|(1<<PB4); //Outputs fr LED1, LED2, FET1, FET2

PORTB |= (1<<PB0);		// LED 1 (grn)  aus
PORTB |= (1<<PB1);		// LED 2 (rot) aus
						// PB2: ADC1
PORTB &=~ (1<<PB3);	// FET 1 aus
PORTB &=~ (1<<PB4);	// FET 2 aus
for(uint16_t j=0;j<30000;j++)asm volatile("nop");
PORTB &=~ (1<<PB1);
for(uint16_t j=0;j<30000;j++)asm volatile("nop");
PORTB |= (1<<PB1);		// LED 2 (rot) aus

WDT_Initialization_as_Wakeup_Source();
sei();

	for(;;){
	
	adc=adc_read(1);        // 14bit-Wert durch Oversampling
	// Ausgang: 
	// Bei Unterschreiten der Entladeschlusspannung FET2 aus, rote LED2 blinkt
	if(adc < min){ PORTB &=~ (1<<PB4); rot=1; } 		// Obacht: FET2 aus, LED2 blinkt
	// Bei berschreiten der Entladeschlusspannung+1500 FET2 an, rote LED2 aus
	else if(adc > min+220){ PORTB |= (1<<PB4); rot=0; }	// Alles klar: FET2 an, LED2 aus
	// Eingang: 
	// Bei Unterschreiten der Ladeschlussspannung-100 (ca. 13.7V) kann geladen werden:
	// Jetzt ist der FET1 aus, die grne LED1 blinkt (PB0)
	if(adc < max-80){ PORTB &=~ (1<<PB3); gruen=1; } // Alles klar: FET1 an, LED1 blinkt 1x
	// Bei berschreiten der Ladeschlussspannung: FET1 aus, die grne LED1 dauernd an (PB0)
	else if(adc > max){ PORTB |= (1<<PB3); gruen=2; }	// Obacht: FET1 aus, LED1 blinkt 2x
	// entsprechend blinken...
	//for(uint16_t j=0;j<30000;j++)asm volatile("nop");
		
		if(rot==1){                                         // 1x blinken
			PORTB |= (1<<PB1);
			for(uint16_t j=0;j<30000;j++)asm volatile("nop");
			PORTB &=~ (1<<PB1);
		}else{                                             // aus
			PORTB &=~ (1<<PB1);
		}
		
		if(gruen==1){                                        // 1x blinken
			PORTB |= (1<<PB0);
			for(uint16_t j=0;j<30000;j++)asm volatile("nop");
			PORTB &=~ (1<<PB0);
		}else if(gruen==2){                                  // 2x blinken
			PORTB |= (1<<PB0);
			for(uint16_t j=0;j<30000;j++)asm volatile("nop");
			PORTB &=~ (1<<PB0);
			for(uint16_t j=0;j<30000;j++)asm volatile("nop");
			PORTB |= (1<<PB0);
			for(uint16_t j=0;j<30000;j++)asm volatile("nop");
			PORTB &=~ (1<<PB0);
		}else{                                               // aus
			PORTB &=~ (1<<PB0);
		}
		
        /* Eine Watchdog-Runde (8 sec) schlafen */
        wdt_reset();                   // Watchdog zurcksetzen
        WDTCR |= (1<<WDTIE);           // Watchdog: Interrupt-Modus aktivieren
		MCUCR |= (1<<SM1) | (1<<SE);  // Power-Down aktivieren
        sleep_mode();
	
	}

return 0;
}
