#include <avr/io.h>
//#include <avr/signal.h>
#include <avr/interrupt.h>
//#include "watchdog.h"


SIGNAL(SIG_WATCHDOG_TIMEOUT)
{
    WDTCR &= ~(1<<WDTIE);              // Disable Watchdog Interrupt Mode
                                        // This can be omitted if repeated interrups are needed
}

/* Initialization routine */
void WDT_Initialization_as_Wakeup_Source( void )
{    
    /* Setup Watchdog */      
    // Use Timed Sequence for disabling Watchdog System Reset Mode if it has been enabled unintentionally.
    MCUSR  &=  ~(1<<WDRF);                                 // Clear WDRF if it has been unintentionally set.
    WDTCR   =   (1<<WDCE )|(1<<WDE  );                     // Enable configuration change.
    WDTCR   =   (1<<WDTIF)|(1<<WDTIE)|                     // Enable Watchdog Interrupt Mode.
                (1<<WDCE )|(0<<WDE  )|                     // Disable Watchdog System Reset Mode if unintentionally enabled.
                (0<<WDP3 )|(1<<WDP2 )|(0<<WDP1)|(1<<WDP0);// Set Watchdog Timeout period to 8.0 sec.

}